#! /usr/bin/python
# Use, distribution, and modification of the RobinPacker binaries, source code,
# or documentation, is subject to the terms of the MIT license.
#
# Copyright (c) 2013 Laurence Dougal Myers
#
# http://opensource.org/licenses/MIT

import collections
import argtypes
Opcode = collections.namedtuple('Opcode', 'value, name, arguments')

conditionalOpcodes = (
    Opcode(0, 'checkCharacterGoalPos', (argtypes.POINT_VALUE,)),
    Opcode(1, 'comparePos', (argtypes.GET_VALUE, argtypes.POINT_VALUE)),
    Opcode(2, 'checkIsoMap3', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(3, 'compareCharacterVariable', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.COMPARE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(4, 'CompareLastRandomValue', (argtypes.COMPARE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(5, 'getRandom', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(6, 'for', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(7, 'compCurrentSpeechId', (argtypes.STRING_REF,)),
    Opcode(8, 'checkSaveFlag', ()),
    Opcode(9, 'compScriptForVal', (argtypes.COMPARE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(10, 'sub174D8', (argtypes.GET_VALUE, argtypes.GET_VALUE)),
    Opcode(11, 'CompareCharacterVariables', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.COMPARE_OPERATION, argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(12, 'compareCoords_1', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(13, 'compareCoords_2', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(14, 'CompareDistanceFromCharacterToPositionWith', (argtypes.POINT_VALUE, argtypes.COMPARE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(15, 'compareRandomCharacterId', (argtypes.GET_VALUE, argtypes.COMPARE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(16, 'IsCurrentCharacterIndex', (argtypes.GET_VALUE,)),
    Opcode(17, 'sub175C8', (argtypes.IMMEDIATE_VALUE, argtypes.GET_VALUE)),
    Opcode(18, 'sub17640', (argtypes.IMMEDIATE_VALUE, argtypes.GET_VALUE)),
    Opcode(19, 'sub176C4', (argtypes.IMMEDIATE_VALUE, argtypes.GET_VALUE)),
    Opcode(20, 'compWord10804', (argtypes.GET_VALUE,)),
    Opcode(21, 'sub17766', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(22, 'sub17782', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(23, 'CompareMapValueWith', (argtypes.POINT_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.COMPARE_OPERATION)),
    Opcode(24, 'IsCharacterValid', (argtypes.GET_VALUE,)),
    Opcode(25, 'compWord16EFE', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(26, 'AreCurrentCharacterVar0AndVar1EqualsTo', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(27, 'CurrentCharacterVar0Equals', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(28, 'checkLastInterfaceHotspotIndexMenu13', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(29, 'checkLastInterfaceHotspotIndexMenu2', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(30, 'CompareNumberOfCharacterWithVar0Equals', (argtypes.IMMEDIATE_VALUE, argtypes.COMPARE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(31, 'IsPositionInViewport', (argtypes.POINT_VALUE,)),
    Opcode(32, 'CompareGameVariables', (argtypes.GET_VALUE, argtypes.GET_VALUE)),
    Opcode(33, 'skipNextOpcode', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(34, 'CurrentCharacterVar2Equals1', ()),
    Opcode(35, 'sub178D2', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(36, 'CharacterVariableAnd', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(37, 'IsCurrentCharacterVar0LessEqualThan', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(38, 'sub1790F', (argtypes.GET_VALUE,)),
    Opcode(39, 'CurrentCharacterVar1Equals', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(40, 'isCurrentCharacterActive', ()),
    Opcode(41, 'CurrentCharacterVar3Equals1', ()),
    Opcode(42, 'sub1796E', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(43, 'checkLastInterfaceHotspotIndex', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(44, 'checkSelectedCharacter', ()),
    Opcode(45, 'checkDelayedReactivation', ()),
    Opcode(46, 'sub179C2', (argtypes.POINT_VALUE,)),
    Opcode(47, 'checkFunctionKeyPressed', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(48, 'checkCodeEntered', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(49, 'checkViewPortCharacterTarget', (argtypes.GET_VALUE,)),
)
conditionalOpcodesLookup = {opcode.name : opcode for opcode in conditionalOpcodes}

actionOpcodes = (
    Opcode(0, 'setWord18821', (argtypes.GET_VALUE,)),
    Opcode(1, 'ChangeIsoMap', (argtypes.POINT_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(2, 'startSpeech', (argtypes.STRING_REF,)),
    Opcode(3, 'getComputedVariantSpeech', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.STRING_REF)),
    Opcode(4, 'getRotatingVariantSpeech', (argtypes.STRING_REF, argtypes.IMMEDIATE_VALUE)),
    Opcode(5, 'startSpeechIfMute', (argtypes.STRING_REF,)),
    Opcode(6, 'getComputedVariantSpeechIfMute', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.STRING_REF)),
    Opcode(7, 'startSpeechIfSilent', (argtypes.STRING_REF, argtypes.IMMEDIATE_VALUE)),
    Opcode(8, 'ComputeCharacterVariable', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.COMPUTE_OPERATION, argtypes.IMMEDIATE_VALUE)),
    Opcode(9, 'getRandom_type2', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(10, 'setCharacterPosition', (argtypes.GET_VALUE, argtypes.POINT_VALUE)),
    Opcode(11, 'DisableCharacter', (argtypes.GET_VALUE,)),
    Opcode(12, 'saveAndQuit', ()),
    Opcode(13, 'sub17B93', (argtypes.IMMEDIATE_VALUE,)), # may be "jump to other opcode"
    Opcode(14, 'startSpeech5', ()),
    Opcode(15, 'resetByte1714E', ()),
    Opcode(16, 'deleteSavegameAndQuit', ()),
    Opcode(17, 'incScriptForVal', ()),
    Opcode(18, 'sub17BA5', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.COMPUTE_OPERATION, argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(19, 'setByte18823', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(20, 'callScript', (argtypes.IMMEDIATE_VALUE, argtypes.GET_VALUE)), # "run script"
    Opcode(21, 'callScriptAndReturn', (argtypes.IMMEDIATE_VALUE, argtypes.GET_VALUE)), # "run script then stop"
    Opcode(22, 'setCurrentScriptCharacterPos', (argtypes.POINT_VALUE,)),
    Opcode(23, 'initScriptFor', ()),
    Opcode(24, 'sub17AE1', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(25, 'sub17AEE', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(26, 'setWord10804', (argtypes.GET_VALUE,)),
    Opcode(27, 'sub17C0E', ()),
    Opcode(28, 'sub17C55', (argtypes.GET_VALUE, argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(29, 'sub17C76', (argtypes.GET_VALUE,)),
    Opcode(30, 'setCurrentCharacter', (argtypes.GET_VALUE,)),
    Opcode(31, 'sub17C8B', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(32, 'sub17CA2', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(33, 'sub17CB9', (argtypes.IMMEDIATE_VALUE, argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(34, 'sub17CD1', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(35, 'resetWord16EFE', ()),
    Opcode(36, 'enableCurrentCharacterScript', (argtypes.IMMEDIATE_VALUE,)), # "stop script"
    Opcode(37, 'IncCurrentCharacterVar1', ()),
    Opcode(38, 'sub17D23', (argtypes.IMMEDIATE_VALUE, argtypes.POINT_VALUE)),
    Opcode(39, 'sub17E6D', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(40, 'changeCurrentCharacterSprite', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(41, 'sub17E99', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(42, 'sub17EC5', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(43, 'setCharacterDirectionTowardsPos', (argtypes.POINT_VALUE,)),
    Opcode(44, 'turnCharacterTowardsAnother', (argtypes.GET_VALUE,)),
    Opcode(45, 'sub17F4F', (argtypes.GET_VALUE,)),
    Opcode(46, 'scrollAwayFromCharacter', ()),
    Opcode(47, 'skipNextVal', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(48, 'setCurrentCharacterVar6', (argtypes.GET_VALUE,)),
    Opcode(49, 'sub17FDD', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(50, 'setCharacterScriptEnabled', (argtypes.GET_VALUE,)),
    Opcode(51, 'setCurrentCharacterVar2', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(52, 'SetCurrentCharacterVar2ToZero', ()),
    Opcode(53, 'setCharacterProperties', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(54, 'sub1805D', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(55, 'sub18074', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(56, 'setCurrentCharacterDirection', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(57, 'setInterfaceHotspot', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(58, 'scrollViewPort', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(59, 'setViewPortPos', (argtypes.POINT_VALUE,)),
    Opcode(60, 'setCurrentCharacterAltitude', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(61, 'sub1817F', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(62, 'sub181BB', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(63, 'sub18213', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(64, 'sub18252', (argtypes.GET_VALUE,)),
    Opcode(65, 'sub18260', (argtypes.GET_VALUE, argtypes.POINT_VALUE)),
    Opcode(66, 'CharacterVariableAddOrRemoveFlag', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(67, 'PaletteFadeOut', ()),
    Opcode(68, 'PaletteFadeIn', ()),
    Opcode(69, 'loadAndDisplayCUBESx_GFX', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(70, 'setCurrentCharacterVar3', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(71, 'setArray122C1', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(72, 'sub18367', ()),
    Opcode(73, 'enableCharacterScript', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(74, 'setRulesBuffer2Element', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(75, 'setDebugFlag', ()),
    Opcode(76, 'setByte14837', ()),
    Opcode(77, 'waitForEvent', ()),
    Opcode(78, 'disableInterfaceHotspot', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(79, 'loadFileAerial', ()),
    Opcode(80, 'startSpeechIfSoundOff', (argtypes.STRING_REF,)),
    Opcode(81, 'sub1844A', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(82, 'displayNumericCharacterVariable', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(83, 'displayVGAFile', (argtypes.STRING_REF,)),
    Opcode(84, 'startSpeechWithoutSpeaker', (argtypes.STRING_REF,)),
    Opcode(85, 'displayTitleScreen', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(86, 'initGameAreaDisplay', ()),
    Opcode(87, 'displayCharacterStatBar', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(88, 'initSmallAnim', (argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(89, 'setCharacterHeroismBar', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(90, 'sub18690', (argtypes.GET_VALUE, argtypes.POINT_VALUE)),
    Opcode(91, 'setViewPortCharacterTarget', (argtypes.GET_VALUE,)),
    Opcode(92, 'sub186A1', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(93, 'sub186E5_snd', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(94, 'sub1870A_snd', (argtypes.POINT_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(95, 'sub18725_snd', (argtypes.GET_VALUE,)),
    Opcode(96, 'sub18733_snd', (argtypes.GET_VALUE,)),
    Opcode(97, 'sub1873F_snd', (argtypes.POINT_VALUE,)),
    Opcode(98, 'sub18746_snd', (argtypes.IMMEDIATE_VALUE,)),
    Opcode(99, 'sub1875D_snd', ()),
    Opcode(100, 'setCharacterMapColor', (argtypes.GET_VALUE, argtypes.IMMEDIATE_VALUE)),
    Opcode(101, 'initGameAreaDisplay2', ()),
)
actionOpcodesLookup = {opcode.name : opcode for opcode in actionOpcodes}
